<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ViewUnpaidInvoice()
  ===================================================*/

  function ViewUnpaidInvoice() {

    global $dbConn, $admin_template_path, $pg_which, $order_by, $asc;

    if (empty($pg_which)) {
      $pg_which = 1;
    }

    // refine value, prevent sql hijacking

    if ($asc == '1')
      $asc_desc = "asc";
    else
      $asc_desc = "desc";

    if ($order_by == 'invoice_date') { }
    elseif ($order_by == 'invoiced_to') { }
    elseif ($order_by == 'total') { }
    elseif ($order_by == 'due_date') { }
    else $order_by = '';

    $currency = $dbConn->Lookup('currency_symbol', 'idx_invoice_config', '0 = 0');

    $query = "select * from idx_invoice where paid = 0 and now()>due_date order by";

    if (empty ($order_by)) {
      $query .= " invoice_date asc";
    }
    else {
      $query .= " $order_by $asc_desc";
    }

    $result          = $dbConn->PageExecute($query, $pg_which, 30);
    $num_rows        = $result->RecordCount();

    // nav

    $nav             = new navigator;
    $nav->pg_size    = 30;
    $nav->href       = 'inv_unpaid.php';
    $nav->more_param = '';
    $nav->pg_which   = $pg_which;
    $nav->rec_count  = $num_rows;
    $nav->init();
    $pagination      = $nav->print_all();
    $i               = $nav->rec_start;

    $invoice         = array();
    while ($row = $result->FetchRow()) {
      $invoice[] = $row;
    }

    $tpl = new Template;
    $tpl->template_dir = $admin_template_path;
    $tpl->assign('invoice', $invoice);
    $tpl->assign('currency', $currency);
    $tpl->assign('pagination', $pagination);
    $tpl->display('inv_overdue.html');
  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";
  
  RunPreFilter(__FILE__);

  DisplayTemplate($admin_template_path . "header.html");
  ViewUnpaidInvoice();
  DisplayTemplate($admin_template_path . "footer.html");

  RunPostFilter(__FILE__);

?>